{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 05.10.98 - 19:50:52 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, MMObj, MMDIBCv, MMSpGram, MMDSPObj, MMWavIn, MMUtils, MMFFT,
  MMThread;

type
  TForm1 = class(TForm)
    WaveIn: TMMWaveIn;
    btnStart: TButton;
    btnStop: TButton;
    MMThread: TMMThread;
    Label1: TLabel;
    lblOverflows: TLabel;
    Spectrogram: TMMSpectrogram;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure MMThreadThread(Sender: TObject);
    procedure MMThreadTerminate(Sender: TObject);
  private
    FDataSection: TRtlCriticalSection;
    FDataBuffer : PChar;
    FDataLength : Longint;
    FBytesLoaded: integer;
    FOverflows  : integer;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
    Overlap = 8;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveIn.Close;
   MMThread.Terminate;

   while not MMThread.Terminated do Sleep(1);
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStartClick(Sender: TObject);
begin
   WaveIn.Buffersize := 2*Spectrogram.BytesPerSpectrogram;
   FDataLength       := 20*WaveIn.Buffersize;
   GetMem(FDataBuffer,FDataLength);

   InitializeCriticalSection(FDataSection);

   FBytesLoaded := 0;
   FOverflows   := 0;

   WaveIn.Start;

   MMThread.Execute;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveIn.Close;
   MMThread.Terminate;
end;

{------------------------------------------------------------------------------}
procedure TForm1.MMThreadTerminate(Sender: TObject);
begin
   FreeMem(FDataBuffer);

   DeleteCriticalSection(FDataSection);
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
var
   nBytes: integer;
begin
   { WaveIn has recorded new data }
   EnterCriticalSection(FDataSection);
   try
      nBytes := lpWaveHdr^.dwBytesRecorded;
      { make sure our buffer doesn't overflow }
      if FBytesLoaded+nBytes > FDataLength then
      begin
         nBytes := FDataLength-FBytesLoaded;
         inc(FOverflows);
         lblOverflows.Caption := IntToStr(FOverflows);
      end;

      { put the data in our buffer }
      Move(lpWaveHdr.lpData^,(FDataBuffer+FBytesLoaded)^,nBytes);
      inc(FBytesLoaded,nBytes);
   finally
      LeaveCriticalSection(FDataSection);
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.MMThreadThread(Sender: TObject);
var
   Done,nBytes: integer;
begin
   EnterCriticalSection(FDataSection);
   try
      nBytes := FBytesLoaded;
   finally
      LeaveCriticalSection(FDataSection);
   end;

   Done := 0;

   while (nBytes >= Spectrogram.BytesPerSpectrogram) and not MMThread.Terminating do
   begin
      Spectrogram.RefreshPCMData(FDataBuffer+Done);
      EnterCriticalSection(FDataSection);
      try
         inc(Done,Spectrogram.BytesPerSpectrogram div Overlap);// berlappung
         nBytes := FBytesLoaded - Done;
      finally
         LeaveCriticalSection(FDataSection);
      end;
   end;

   if not MMThread.Terminating then
   begin
      EnterCriticalSection(FDataSection);
      try
         { adjust the loaded bytes }
         FBytesLoaded := FBytesLoaded - Done;

         { copy the remaining bytes }
         if (FBytesLoaded > 0) then
             Move((FDataBuffer+Done)^,FDataBuffer^,FBytesLoaded);
      finally
         LeaveCriticalSection(FDataSection);
      end;
   end;
end;

end.
